﻿#include "precompiled.h"
#include "common.h"
#include "Shutter.h"

const float kInitialShutterSpeed = 1/100.0f;
const float kMinShutterSpeed = 0.0003125f; // Minimum exposure time
//const float kMaxShutterSpeed = 40.96f; // Maximum exposure time
const float kMaxShutterSpeed = 0.01667f; // Maximum exposure time

namespace RTCam {

Shutter::Shutter(void) :
	m_shutterSpeed(kInitialShutterSpeed)
{
}

Shutter::~Shutter(void)
{
}

float Shutter::ValidateShutterSpeed(float shutterSpeed)
{
	return Clamp(shutterSpeed, kMinShutterSpeed, kMaxShutterSpeed);
}

float Shutter::GetShutterSpeed()
{
	return m_shutterSpeed;
}

void Shutter::SetShutterSpeed(float shutterSpeed)
{
	m_shutterSpeed = ValidateShutterSpeed(shutterSpeed);
}

} // end namespace